// SpacingDialog.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "gmnview32.h"
#include "SpacingDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern "C"
{
	_declspec (dllimport) float GetOptForce();
	_declspec (dllimport) void SetOptForce(float newoptforce);
	_declspec (dllimport) int GetOptPageFill();
	_declspec (dllimport) void SetOptPageFill(int newoptpagefill);
	_declspec (dllimport) int GetNeighborhoodSpacing();
	_declspec (dllimport) void getSetting(int setting, float *npar);
	_declspec (dllimport) void setSetting(int setting,float npar);

}


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CSpacingDialog 


CSpacingDialog::CSpacingDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSpacingDialog::IDD, pParent)
{
	m_def_sys_dis_changed = 0;
	float sys_dis;
	getSetting(5,&sys_dis);

	//{{AFX_DATA_INIT(CSpacingDialog)
	m_optforceint = 0;
	m_optpagefill = GetOptPageFill();
	m_specialspacing = GetNeighborhoodSpacing();
	m_def_sys_dis = 0;
	m_dis_auto = (int) sys_dis - 1;
	//}}AFX_DATA_INIT
}


void CSpacingDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpacingDialog)
	DDX_Control(pDX, IDC_DEFAULT_SYS_DIS, m_def_sys_dis_disp);
	DDX_Control(pDX, IDC_SLIDER_DEF_SYS_DIS, m_ctrl_def_sys_dis);
	DDX_Control(pDX, IDC_FORCEDISPLAY, m_ctrl_forcedisplay);
	DDX_Control(pDX, IDC_OPTFORCE, m_slider);
	DDX_Slider(pDX, IDC_OPTFORCE, m_optforceint);
	DDX_Check(pDX, IDC_CHECK1, m_optpagefill);
	DDX_Check(pDX, IDC_SPECRHYTHM, m_specialspacing);
	DDX_Slider(pDX, IDC_SLIDER_DEF_SYS_DIS, m_def_sys_dis);
	DDX_Radio(pDX, IDC_DIS_AUTO, m_dis_auto);
	//}}AFX_DATA_MAP
}


BOOL CSpacingDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	this->m_optpagefill = GetOptPageFill();
	this->m_specialspacing = GetNeighborhoodSpacing();
	m_slider.SetRange(400,1500);

	
	
	float optforce;
	optforce = GetOptForce();

	
	int npos = (int) optforce;
	m_slider.SetPos(npos);

	char mychar[20];
	itoa(npos,mychar,10);
	this->m_ctrl_forcedisplay.SetWindowText(mychar);

	float defsysdis;
	getSetting(4,&defsysdis);
	// this is a value in cm ....
	// map it into an int - range ...
	defsysdis *= 100; 
	if (defsysdis < 10)
		defsysdis = 10;
	if (defsysdis > 400)
		defsysdis = 400;
	m_ctrl_def_sys_dis.SetRange(10,400);
	m_ctrl_def_sys_dis.SetPos((int) defsysdis);
	sprintf(mychar,"%.2fcm",defsysdis / 100.0);
	m_def_sys_dis_disp.SetWindowText(mychar);


	// TODO: Zustzliche Initialisierung hier einfgen
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

BEGIN_MESSAGE_MAP(CSpacingDialog, CDialog)
	//{{AFX_MSG_MAP(CSpacingDialog)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CSpacingDialog 

void CSpacingDialog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	
	if ((CSliderCtrl *) pScrollBar == &m_slider)
	{
		int npos = m_slider.GetPos();

		char mychar[20];
		itoa(npos,mychar,10);
		this->m_ctrl_forcedisplay.SetWindowText(mychar);
	}
	else if ((CSliderCtrl *) pScrollBar == &m_ctrl_def_sys_dis)
	{
		float defsysdis = m_ctrl_def_sys_dis.GetPos();
		if (defsysdis != m_def_sys_dis)
		{
			m_def_sys_dis_changed = 1;
			if (defsysdis < 10)
				defsysdis = 10;
			if (defsysdis > 400)
				defsysdis = 400;
			char mychar[20];
			sprintf(mychar,"%.2fcm",defsysdis / 100.0);
			m_def_sys_dis_disp.SetWindowText(mychar);
		}
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}
